/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics;

import com.google.common.collect.Sets;
import com.simibubi.create.content.schematics.ItemRequirement;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_5250;

public class MaterialChecklist {
    public static final int MAX_ENTRIES_PER_PAGE = 5;
    public Object2IntMap<class_1792> gathered = new Object2IntArrayMap();
    public Object2IntMap<class_1792> required = new Object2IntArrayMap();
    public Object2IntMap<class_1792> damageRequired = new Object2IntArrayMap();
    public boolean blocksNotLoaded;

    public void warnBlockNotLoaded() {
        this.blocksNotLoaded = true;
    }

    public void require(ItemRequirement requirement) {
        if (requirement.isEmpty()) {
            return;
        }
        if (requirement.isInvalid()) {
            return;
        }
        for (ItemRequirement.StackRequirement stack : requirement.requiredItems) {
            if (stack.usage == ItemRequirement.ItemUseType.DAMAGE) {
                this.putOrIncrement(this.damageRequired, stack.stack);
            }
            if (stack.usage != ItemRequirement.ItemUseType.CONSUME) continue;
            this.putOrIncrement(this.required, stack.stack);
        }
    }

    private void putOrIncrement(Object2IntMap<class_1792> map, class_1799 stack) {
        class_1792 item = stack.method_7909();
        if (item == class_1802.field_8162) {
            return;
        }
        if (map.containsKey((Object)item)) {
            map.put((Object)item, map.getInt((Object)item) + stack.method_7947());
        } else {
            map.put((Object)item, stack.method_7947());
        }
    }

    public void collect(class_1799 stack) {
        class_1792 item = stack.method_7909();
        if (this.required.containsKey((Object)item) || this.damageRequired.containsKey((Object)item)) {
            if (this.gathered.containsKey((Object)item)) {
                this.gathered.put((Object)item, this.gathered.getInt((Object)item) + stack.method_7947());
            } else {
                this.gathered.put((Object)item, stack.method_7947());
            }
        }
    }

    public void collect(StorageView<ItemVariant> view) {
        if (view.isResourceBlank()) {
            return;
        }
        int amount = TransferUtil.truncateLong((long)view.getAmount());
        class_1799 stack = ((ItemVariant)view.getResource()).toStack(amount);
        this.collect(stack);
    }

    public class_1799 createItem() {
        class_5250 textComponent;
        class_1799 book = new class_1799((class_1935)class_1802.field_8360);
        class_2487 tag = book.method_7948();
        class_2499 pages = new class_2499();
        int itemsWritten = 0;
        if (this.blocksNotLoaded) {
            textComponent = Components.literal("\n" + class_124.field_1061);
            textComponent = textComponent.method_10852((class_2561)Lang.translateDirect("materialChecklist.blocksNotLoaded", new Object[0]));
            pages.add((Object)class_2519.method_23256((String)class_2561.class_2562.method_10867((class_2561)textComponent)));
        }
        ArrayList keys = new ArrayList(Sets.union((Set)this.required.keySet(), (Set)this.damageRequired.keySet()));
        Collections.sort(keys, (item1, item2) -> {
            Locale locale = Locale.ENGLISH;
            String name1 = item1.method_7848().getString().toLowerCase(locale);
            String name2 = item2.method_7848().getString().toLowerCase(locale);
            return name1.compareTo(name2);
        });
        textComponent = Components.empty();
        ArrayList<class_1792> completed = new ArrayList<class_1792>();
        for (class_1792 item : keys) {
            int amount = this.getRequiredAmount(item);
            if (this.gathered.containsKey((Object)item)) {
                amount -= this.gathered.getInt((Object)item);
            }
            if (amount <= 0) {
                completed.add(item);
                continue;
            }
            if (itemsWritten == 5) {
                itemsWritten = 0;
                textComponent.method_10852((class_2561)Components.literal("\n >>>").method_27692(class_124.field_1078));
                pages.add((Object)class_2519.method_23256((String)class_2561.class_2562.method_10867((class_2561)textComponent)));
                textComponent = Components.empty();
            }
            ++itemsWritten;
            textComponent.method_10852(this.entry(new class_1799((class_1935)item), amount, true));
        }
        for (class_1792 item : completed) {
            if (itemsWritten == 5) {
                itemsWritten = 0;
                textComponent.method_10852((class_2561)Components.literal("\n >>>").method_27692(class_124.field_1077));
                pages.add((Object)class_2519.method_23256((String)class_2561.class_2562.method_10867((class_2561)textComponent)));
                textComponent = Components.empty();
            }
            ++itemsWritten;
            textComponent.method_10852(this.entry(new class_1799((class_1935)item), this.getRequiredAmount(item), false));
        }
        pages.add((Object)class_2519.method_23256((String)class_2561.class_2562.method_10867((class_2561)textComponent)));
        tag.method_10566("pages", (class_2520)pages);
        tag.method_10582("author", "Schematicannon");
        tag.method_10582("title", class_124.field_1078 + "Material Checklist");
        textComponent = Lang.translateDirect("materialChecklist", new Object[0]).method_10862(class_2583.field_24360.method_10977(class_124.field_1078).method_10978(Boolean.FALSE));
        book.method_7911("display").method_10582("Name", class_2561.class_2562.method_10867((class_2561)textComponent));
        book.method_7980(tag);
        return book;
    }

    public int getRequiredAmount(class_1792 item) {
        int amount = this.required.getOrDefault((Object)item, 0);
        if (this.damageRequired.containsKey((Object)item)) {
            amount = (int)((double)amount + Math.ceil((float)this.damageRequired.getInt((Object)item) / (float)new class_1799((class_1935)item).method_7936()));
        }
        return amount;
    }

    private class_2561 entry(class_1799 item, int amount, boolean unfinished) {
        int stacks = amount / 64;
        int remainder = amount % 64;
        class_5250 tc = Components.empty();
        tc.method_10852((class_2561)Components.translatable(item.method_7922()).method_10862(class_2583.field_24360.method_10949(new class_2568(class_2568.class_5247.field_24343, (Object)new class_2568.class_5249(item)))));
        if (!unfinished) {
            tc.method_27693(" \u2714");
        }
        tc.method_27692(unfinished ? class_124.field_1078 : class_124.field_1077);
        return tc.method_10852((class_2561)Components.literal("\n x" + amount).method_27692(class_124.field_1074)).method_10852((class_2561)Components.literal(" | " + stacks + "\u25a4 +" + remainder + "\n").method_27692(class_124.field_1080));
    }
}

